// Apple's Currency Converter example in Objective Modula-2
//
// ConverterController.def -- Converter controller implementation
//
// www.sunrisetel.net/software/devtools/ObjM2/samples/ConverterController.mod

IMPLEMENTATION MODULE ConverterController : NSObject;

IMPORT Cocoa; <*FRAMEWORK*>

INSTANCE METHOD convert: (sender : OBJECT); <*IBAction*>
VAR
    amount : REAL;
    converter : Converter;
    
BEGIN
    (* initialise a Converter object *)
    converter := [[Converter alloc] init];
    
    (* set the instance variables of converter *)
    [converter setSourceCurrencyAmount:[dollarField floatValue]];
    
    (* send convertCurrency message to converter and store result in amount *)
    amount := [converter convertCurrency];
    
    (* write amount to text field amountField *)
    [amountField setFloatValue:amount];
    
    (* send selectText: message to rateField *)
    [rateField selectText:self];
    
END; (* convert: *)

END ConverterController.