/*
 *  calc_hashes.c
 *  objm2c
 *
 */

/* utility to calculate hashes for the smybol table */

#include <stdio.h>
#include <stdlib.h>
#include "objm2_hash.h"

int main (int argc, const char **argv) {
    unsigned int i, j, hash;
    unsigned char *kw;
	
    if (argc <= 1) {
        printf("usage: calc_hashes string { string }\n");
        exit(1);
    } // end if

    for (i = 1; i < argc; i++) {
    
        kw = (unsigned char *)argv[i];
                
        j = 0;
        hash = OBJM2_HASH_INITIAL;
        
        while (kw[j] != 0) {
            hash =  OBJM2_HASH_NEXT_CHAR(hash, kw[j]);
            j++;
        } // end while
        
        hash = OBJM2_HASH_FINAL(hash);

        printf("0x%8X   /* %s */\n", hash, kw);

    } // end for
    
    return 0;
} // end main

// END OF FILE