/*  Definitions for common macros
 *
 *  @file common_macros.h
 *
 *  Created by Sunrise Telephone Systems KK
 *
 *  This file ("common_macros.h") is hereby released into the public domain.
 */

#ifndef COMMON_MACROS_H
#define COMMON_MACROS_H

#define fmacro inline __attribute__((always_inline))

#define NOT(x) !(x)

#define MAX(x,y)	((x) > (y) ? (x) : (y))
#define MAX3(x,y,z)	((x) > (y) ? MAX(x,z) : MAX(y,z))

#define MIN(x,y)	((x) < (y) ? (x) : (y))
#define MIN3(x,y,z)	((x) < (y) ? MIN(x,z) : MIN(y,z))

#define loop while(1)
#define repeat do
#define until(x) while (!(x))

#define EMPTY_STRING "\0"

#define SET_FPOS(_fpos,_line,_col) _fpos.line=_line; _fpos.col=_col;

#endif /* COMMON_MACROS_H */

// END OF FILE