/*  Definitions for common data types
 *
 *  @file common_types.h
 *
 *  Created by Sunrise Telephone Systems KK
 *
 *  This file ("common_types.h") is hereby released into the public domain.
 *
 */

#ifndef COMMON_TYPES_H
#define COMMON_TYPES_H

#include <stdint.h>
#include <stdbool.h>

typedef void *opaque_t;

typedef unsigned char uchar_t;

typedef uint8_t octet_t;
typedef uint16_t word_t;
typedef uint32_t uint_t;
typedef unsigned int cardinal;

typedef struct {
	word_t  length;
	octet_t octet[0];
} dbuf_t;

typedef struct {
    uint16_t line;
    uint16_t col;
} file_pos_t;

typedef struct {
    cardinal line;
    cardinal col;
} long_file_pos_t;


#endif /* COMMON_TYPES_H */

// END OF FILE