/* Objective Modula-2 Compiler (objm2c)
 *
 *  @file objm2_ast.h
 *
 *  Abstract syntax tree interface
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-05-30   BK   new file
 */

#ifndef OBJM2_AST_H
#define OBJM2_AST_H


#include "common_types.h"


// ---------------------------------------------------------------------------
// Opaque AST node handle type
// ---------------------------------------------------------------------------
//
// WARNING:  Objects of this opaque type should  only be accessed through this
// public interface.  DO NOT EVER attempt to bypass the public interface.
//
// The internal data structure of this opaque type is  HIDDEN  and  MAY CHANGE
// at any time WITHOUT NOTICE.  Accessing the internal data structure directly
// other than  through the  functions  in this public interface is  UNSAFE and
// may result in an inconsistent program state or a crash.

typedef opaque_t objm2_ast_node_t;


// ---------------------------------------------------------------------------
// Status codes
// ---------------------------------------------------------------------------

typedef /* objm2_ast_status_t */ enum {
    OBJM2_KVS_STATUS_UNDEFINED = -1,
    OBJM2_KVS_STATUS_SUCCESS = 1,
    OBJM2_KVS_STATUS_UNABLE_TO_ALLOCATE
} objm2_ast_status_t;


// ---------------------------------------------------------------------------
// function:  objm2_ast_new_node(token, lexeme, status)
// ---------------------------------------------------------------------------
//
// Returns a new AST node for token with lexeme.


// ---------------------------------------------------------------------------
// function:  objm2_ast_add_child(parent, child, status)
// ---------------------------------------------------------------------------
//
// Adds node child to node parent. Returns void.


// ---------------------------------------------------------------------------
// function:  objm2_ast_token(node, status)
// ---------------------------------------------------------------------------
//
// Returns the token of node.


// ---------------------------------------------------------------------------
// function:  objm2_ast_lexeme(node, status)
// ---------------------------------------------------------------------------
//
// Returns the lexeme of node.


// ---------------------------------------------------------------------------
// function:  objm2_ast_parent(node, status)
// ---------------------------------------------------------------------------
//
// Returns the parent of node.


// ---------------------------------------------------------------------------
// function:  objm2_ast_child(node, index, status)
// ---------------------------------------------------------------------------
//
// Returns the child of node at index.


// ---------------------------------------------------------------------------
// function:  objm2_ast_child_count(node, status)
// ---------------------------------------------------------------------------
//
// Returns the number of children of node.


// ---------------------------------------------------------------------------
// function:  objm2_ast_is_parent(node, child, status)
// ---------------------------------------------------------------------------
//
// Returns true if node is the parent of child, false otherwise.


#endif /* OBJM2_AST_H */

// END OF FILE