/* Objective Modula-2 Compiler (objm2c)
 *
 *  @file objm2_build_params.h
 *
 *  User definable build parameters for the compiler
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-03-27   BK   new file
 *
 */


#ifndef OBJM2_BUILD_PARAMS_H
#define OBJM2_BUILD_PARAMS_H

#include "common_types.h"


// ===========================================================================
// P U B L I C   S E C T I O N  -  U S E R   D E F I N A B L E   V A L U E S
// ===========================================================================

// ---------------------------------------------------------------------------
// User definable parameters
// ---------------------------------------------------------------------------

// maximum length allowed for path names
#define OBJM2_MAX_PATHNAME_LENGTH 256

// maximum length allowed for identifiers
#define OBJM2_MAX_IDENT_LENGTH    32

// maximum length allowed for number literals
#define OBJM2_MAX_NUM_LENGTH      32

// maximum length allowed for string literals
#define OBJM2_MAX_STRING_LENGTH   4096

// maximum length allowed for tokenised comments
#define OBJM2_MAX_COMMENT_LENGTH  4096

// maximum nesting level for nested comments
#define OBJM2_MAX_NESTED_COMMENTS 32


// ===========================================================================
// P R I V A T E   S E C T I O N  -  D O   N O T   M O D I F Y ! ! !
// ===========================================================================

// ---------------------------------------------------------------------------
// Parameter integrity checks
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_PATHNAME_LENGTH <= 1)
#error "illegal value for OBJM2_MAX_PATHNAME_LENGTH"
#elif (OBJM2_MAX_PATHNAME_LENGTH < 32)
#warning "unreasonably low value for OBJM2_MAX_PATHNAME_LENGTH"
#elif (OBJM2_MAX_PATHNAME_LENGTH > 512)
#warning "unreasonably high value for OBJM2_MAX_PATHNAME_LENGTH"
#endif

#if (OBJM2_MAX_IDENT_LENGTH <= 1)
#error "illegal value for OBJM2_MAX_IDENT_LENGTH"
#elif (OBJM2_MAX_IDENT_LENGTH < 8)
#warning "unreasonably low value for OBJM2_MAX_IDENT_LENGTH"
#elif (OBJM2_MAX_IDENT_LENGTH > 80)
#warning "unreasonably high value for OBJM2_MAX_IDENT_LENGTH"
#endif

#if (OBJM2_MAX_NUM_LENGTH <= 1)
#error "illegal value for OBJM2_MAX_NUM_LENGTH"
#elif (OBJM2_MAX_NUM_LENGTH < 8)
#warning "unreasonably low value for OBJM2_MAX_NUM_LENGTH"
#elif (OBJM2_MAX_NUM_LENGTH > 80)
#warning "unreasonably high value for OBJM2_MAX_NUM_LENGTH"
#endif

#if (OBJM2_MAX_STRING_LENGTH <= 3)
#error "illegal value for OBJM2_MAX_STRING_LENGTH"
#elif (OBJM2_MAX_STRING_LENGTH < 80)
#warning "unreasonably low value for OBJM2_MAX_STRING_LENGTH"
#elif (OBJM2_MAX_STRING_LENGTH > 4096)
#warning "unreasonably high value for OBJM2_MAX_STRING_LENGTH"
#endif

#if (OBJM2_MAX_COMMENT_LENGTH <= 5)
#error "illegal value for OBJM2_MAX_COMMENT_LENGTH"
#elif (OBJM2_MAX_COMMENT_LENGTH < 80)
#warning "unreasonably high value for OBJM2_MAX_COMMENT_LENGTH"
#elif (OBJM2_MAX_COMMENT_LENGTH > 4096)
#warning "unreasonably high value for OBJM2_MAX_COMMENT_LENGTH"
#endif

#if (OBJM2_MAX_NESTED_COMMENTS <= 1)
#error "illegal value for OBJM2_MAX_NESTED_COMMENTS"
#elif (OBJM2_MAX_NESTED_COMMENTS < 3)
#warning "unreasonably low value for OBJM2_MAX_NESTED_COMMENTS"
#elif (OBJM2_MAX_NESTED_COMMENTS > 32)
#warning "unreasonably high value for OBJM2_MAX_NESTED_COMMENTS"
#endif


// ---------------------------------------------------------------------------
// Index type for pathname iteration
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_PATHNAME_LENGTH >= 0xffff)
#error "illegal value for OBJM2_MAX_PATHNAME_LENGTH"
#elif (OBJM2_MAX_PATHNAME_LENGTH >= 0xff)
typedef uint16_t pathname_index_t;
#else
typedef uint8_t pathname_index_t;
#endif


// ---------------------------------------------------------------------------
// Index type for identifier lexeme iteration
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_IDENT_LENGTH >= 0xffff)
#error "illegal value for OBJM2_MAX_IDENT_LENGTH"
#elif (OBJM2_MAX_IDENT_LENGTH >= 0xff)
typedef uint16_t ident_index_t;
#else
typedef uint8_t ident_index_t;
#endif


// ---------------------------------------------------------------------------
// Index type for numeric literal iteration
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_NUM_LENGTH >= 0xffff)
#error "illegal value for OBJM2_MAX_NUM_LENGTH"
#elif (OBJM2_MAX_NUM_LENGTH >= 0xff)
typedef uint16_t num_index_t;
#else
typedef uint8_t num_index_t;
#endif


// ---------------------------------------------------------------------------
// Index type for string literal iteration
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_STRING_LENGTH >= 0xffff)
#error "illegal value for OBJM2_MAX_STRING_LENGTH"
#elif (OBJM2_MAX_STRING_LENGTH >= 0xff)
typedef uint16_t string_index_t;
#else
typedef uint8_t string_index_t;
#endif


// ---------------------------------------------------------------------------
// Index type for comment iteration
// ---------------------------------------------------------------------------

#if (OBJM2_MAX_COMMENT_LENGTH >= 0xffff)
#error "illegal value for OBJM2_MAX_COMMENT_LENGTH"
#elif (OBJM2_MAX_COMMENT_LENGTH >= 0xff)
typedef uint16_t comment_index_t;
#else
typedef uint8_t comment_index_t;
#endif

#endif /* OBJM2_BUILD_PARAMS_H */

// END OF FILE