/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_builtin_ident_table.h
 *  Built-in identifier master table
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objextive Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-01-31   BK   new file
 */

// This  file  represents the  BUILT-IN IDENTIFIER MASTER TABLE  for the ObjM2
// compiler,  which is used  to derive  other tables which contain identifiers
// and  it thereby  keeps those tables  in synchronisation.  Consequently, any
// changes, additions or removals of built-in identifiers must be made in this
// file, not anywhere else.  Failing to do so  will  result  in  an  incorrect
// compiler as tables will no longer be synchronised.
//
// How to use this master table:
//
// The  following  code  will  generate  a declaration  for  an enumeration of
// predefined identifiers prefixed with KEYWORD ...
//
//  #define _add_ident(_suffix, _hash) IDENT ## _suffix,
//  enum objm2_builtin_ident_t {
//  #include "objm2_builtin_ident_table.h"
//  } /* objm2_builtin_ident_t */;
//  #undef _add_ident
//
// Arguments for the _add_ident macro:
//
//  1st: identifier suffix, must be preceeded by an underscore
//  2nd: hash value for the symbol table, integer

_add_ident( _ABS, 0x20440052)
_add_ident( _BITSET, 0x0338C055)
_add_ident( _BOOLEAN, 0x76F607C8)
_add_ident( _CAP, 0x213F1F12)
_add_ident( _CARDINAL, 0x1EA3C640)
_add_ident( _CHAR, 0x50FE0E96)
_add_ident( _CHR, 0x214620CD)
_add_ident( _DEC, 0x21C12F82)
_add_ident( _EXCL, 0x35EEA89C)
_add_ident( _FALSE, 0x089CA9C3)
_add_ident( _FLOAT, 0x09CFCC1C)
_add_ident( _HALT, 0x3638B881)
_add_ident( _HIGH, 0x3A243342)
_add_ident( _INC, 0x24407F3E)
_add_ident( _INCL, 0x6B1D508E)
_add_ident( _INTEGER, 0x4AE471DE)
_add_ident( _LONGCARD, 0x6630FF2C)
_add_ident( _LONGINT, 0x2A1A2753)
_add_ident( _LONGREAL, 0x21FE743A)
_add_ident( _MAX, 0x262BBA24)
_add_ident( _MIN, 0x2633BC12)
_add_ident( _NIL, 0x26B1CB91)
_add_ident( _NO, 0x004E1381)       /* ObjM2 extension */
_add_ident( _OBJECT, 0x6FD8167F)   /* ObjM2 extension */
_add_ident( _ODD, 0x272AD9CF)
_add_ident( _ORD, 0x2738DD41)
_add_ident( _PROC, 0x32D146B6)
_add_ident( _REAL, 0x096A1B3E)
_add_ident( _SIZE, 0x3A023021)
_add_ident( _TRUE, 0x6CF28B2E)
_add_ident( _TRUNC, 0x5AE742CC)
_add_ident( _UNICHAR, 0x0D2BF7E6)  /* ObjM2 extension */
_add_ident( _VAL, 0x2A9A45A1)
_add_ident( _YES, 0x2C187527)      /* ObjM2 extension */

// END OF FILE