/*  Gemeral purpose 32-bit hash function
 *
 *  objm2_hash.h
 *
 *  Created by Sunrise Telephone Systems KK
 *
 *  This file ("objm2_hash.h") is hereby released into the public domain.
 *
 */

#ifndef OBJM2_HASH_H
#define OBJM2_HASH_H

// undefine if hash algorithm is replaced
#define OBJM2_HASH_ALGORITHM_IS_ORIGINAL

// initial value
#define OBJM2_HASH_INITIAL 0

// iterative value
#define OBJM2_HASH_NEXT_CHAR(_hash,_ch) \
    (_ch + (_hash << 6) + (_hash << 16) - _hash)

// final value
#define OBJM2_HASH_FINAL(_hash) (hash & 0x7FFFFFFF)

#endif /* OBJM2_HASH_H */

// END OF FILE