/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_reserved_words.h
 *  Minimal Perfect Hash for Objective Modula-2 reserved words
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-01-31   BK   new file, replaces v.1 keywords.h
 */

#ifndef OBJM2_RESERVED_WORDS_H
#define OBJM2_RESERVED_WORDS_H

#include "common_types.h"


// ---------------------------------------------------------------------------
// Total number of reserved words
// ---------------------------------------------------------------------------

#define OBJM2_NUMBER_OF_RESERVED_WORDS  _OBJM2_NUMBER_OF_RESERVED_WORDS


// ---------------------------------------------------------------------------
// Length of longest reserved word
// ---------------------------------------------------------------------------

#define OBJM2_MAX_RESERVED_WORD_LENGTH  14


// ---------------------------------------------------------------------------
// Index values for reserved words
// ---------------------------------------------------------------------------

#define _add_reserved_word(_suffix, _hash) OBJM2_RESERVED_WORD_INDEX ## _suffix,

typedef /* objm2_reserved_word_t */ enum {
// insert reserved words from master table
#include "objm2_reserved_word_table.h"
_OBJM2_NUMBER_OF_RESERVED_WORDS
} objm2_reserved_word_t;

#undef _add_reserved_yword


// ---------------------------------------------------------------------------
// function:  objm2_hash_for_reserved_word(index)
// ---------------------------------------------------------------------------
//
// Returns the  stored hash value for the reserved word  associated with index
// <index>.  If <index> is  greater than  or equal to  the  number of reserved
// words as defined by OBJM2_NUMBER_OF_RESERVED_WORDS, then zero is returned.

cardinal objm2_hash_for_reserved_word(cardinal index);


// ---------------------------------------------------------------------------
// function:  objm2_index_for_reserved_word(lexeme, hash)
// ---------------------------------------------------------------------------
//
// Returns the hash table index for the reserved word  represented by <lexeme>
// and <hash>.  If zero is passed for <hash>, the its value will be calculated
// from <lexeme>.  The function executes  slightly faster  if it does not need
// to calculate the storage hash value.
//
// Return values are between 1 and OBJM2_NUMBER_OF_RESERVED_WORDS - 1.  If the
// hash value passed  does not represent  a valid reserved word,  or,  if zero
// was passed for <hash>  and  the string passed in <lexeme>  is  not  a valid
// reserved word,  then  OBJM2_NUMBER_OF_RESERVED_WORDS  is returned.

cardinal objm2_index_for_reserved_word(const char *lexeme, cardinal hash);


#endif /* OBJM2_RESERVED_WORDS_H */

// END OF FILE