/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_symbols.c
 *  Implementation of predefined symbols
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-03-25   BK   new file
 */

#include "objm2_symbols.h"

#define OBJM2_SYMBOL_NULL_FLAGS \
    { false, false, false, false, false, \
      false, false, false, false, false, \
      false, false, false, false, false }

// --------------------------------------------------------------------------
// Predefined flags constant with all flags cleared
// --------------------------------------------------------------------------

const objm2_symbol_flags_t objm2_symbol_null_flags = OBJM2_SYMBOL_NULL_FLAGS;


// --------------------------------------------------------------------------
// Predefined symbol constant with all fields cleared
// --------------------------------------------------------------------------

const objm2_symbol_s objm2_symbol_null_symbol =
    { 0, 0, 0, OBJM2_SYMBOL_NULL_FLAGS, { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } };


// END OF FILE