/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_tokens.h
 *  Token master table
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objextive Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-01-31   BK   new file
 */

// This file  represents the TOKEN MASTER TABLE for the ObjM2 compiler,  which
// is used to derive other token related tables and  thereby keep those tables
// in synchronisation.  Consequently,  any changes,  additions  or removals of
// tokens must be made in this file, not anywhere else.  Failing to do so will
// result in an incorrect compiler as tables will no longer be synchronised.
//
// How to use this master table:
//
// The following code  will generate a declaration for an enumeration of token
// identifiers prefixed with TOKEN ...
//
//  #define _add_token(_suffix, _desc) TOKEN ## _suffix,
//  enum objm2_token_t {
//  #include "objm2_token_table.h"
//  } /* objm2_token_t */;
//  #undef _add_token
//
// Arguments for the _add_token macro:
//
//  1st: token identifier suffix, must be preceeded by an underscore
//       used to construct token identifiers for use by the lexer and parser
//
//  2nd: human readable name, double quoted string describing the token
//       used as substrings within error messages and warnings

_add_token( _IDENTIFIER, "identifier")
_add_token( _LABELED_IDENTIFIER, "labeled identifier")
_add_token( _OCTAL_INTEGER_LITERAL, "octal integer literal")
_add_token( _DECIMAL_INTEGER_LITERAL, "decimal integer literal")
_add_token( _SEDECIMAL_INTEGER_LITERAL, "sedecimal integer literal")
_add_token( _REAL_NUMBER_LITERAL, "real number literal")
_add_token( _ASCII_CHAR_LITERAL, "ASCII character code literal")
_add_token( _UNICODE_CHAR_LITERAL, "UNICHAR character code literal")
_add_token( _QUOTED_CHAR_LITERAL, "quoted character literal")
_add_token( _STRING_LITERAL, "string literal")
_add_token( _ASSIGN_OP, "\":=\"")
_add_token( _MESSAGE_PREFIX, "\"`\"")
_add_token( _LOGICAL_AND_OP, "\"&\"")
_add_token( _LOGICAL_NOT_OP, "\"~\", or \"!\"")
_add_token( _EQUAL_OP, "\"=\"")
_add_token( _NOT_EQUAL_OP, "\"#\", \"<>\", or \"!=\"")
_add_token( _GREATER_OP, "\">\"")
_add_token( _GREATER_OR_EQUAL_OP, "\">=\"")
_add_token( _LESS_OP, "\"<\"")
_add_token( _LESS_OR_EQUAL_OP, "\"<=\"")
_add_token( _PLUS_OP, "\"+\"")
_add_token( _INCREMENT_OP, "\"++\"")
_add_token( _MINUS_OP, "\"-\"")
_add_token( _DECREMENT_OP, "\"--\"")
_add_token( _MULTIPLY_OP, "\"*\"")
_add_token( _DIVIDE_OP, "\"/\"")
_add_token( _POINTER_OP, "\"^\"")
_add_token( _OPENING_PARENTHESIS, "\"(\"")
_add_token( _CLOSING_PARENTHESIS, "\")\"")
_add_token( _OPENING_BRACKET, "\"[\"")
_add_token( _CLOSING_BRACKET, "\"]\"")
_add_token( _OPENING_BRACE, "\"{\"")
_add_token( _CLOSING_BRACE, "\"}\"")
_add_token( _DOT, "\".\"")
_add_token( _DOT_DOT, "\"..\"")
_add_token( _COMMA, "\",\"")
_add_token( _COLON, "\":\"")
_add_token( _SEMICOLON, "\";\"")
_add_token( _VERTICAL_BAR, "\"|\"")
_add_token( _PRAGMA, "compiler pragma")
_add_token( _C_COMMENT, "C comment")
_add_token( _M2_COMMENT, "Modula-2 comment")
_add_token( _CPP_COMMENT, "BCPL/C++ comment")
_add_token( _EOF_MARKER, "end-of-file marker")

// Unicode character literal, message prefix, increment operator,
// decrement operator, C comment and C++ comment are ObjM2 extensions

// END OF FILE