/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_tokens.h
 *  Implementation of compiler tokens
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-01-31   BK   new file
 */

#include <stdlib.h>
#include "common_macros.h"
#include "objm2_tokens.h"


// ---------------------------------------------------------------------------
// Human readable names of tokens
// ---------------------------------------------------------------------------

typedef char *objm2_token_name_t;

#define _add_token(_suffix, _desc) \
static const char _TOKNAM ## _suffix[] = _desc EMPTY_STRING;

#define _add_keyword(_suffix, _hash) \
static const char _TOKNAM ## _suffix[] = # _suffix EMPTY_STRING;

const char _TOKNAM_ILLEGAL_CHARACTER[] = "illegal character\0";
#include "objm2_keyword_table.h"
#include "objm2_token_table.h"

#undef _add_token
#undef _add_keyword


// ---------------------------------------------------------------------------
// Table of human readable token names
// ---------------------------------------------------------------------------

#define _add_token(_suffix, _desc) (char *)&_TOKNAM ## _suffix,
#define _add_keyword(_suffix, _hash) (char *)&_TOKNAM ## _suffix+1,
// to skip preceeding underscore each keyword string address is incremented

static const objm2_token_name_t objm2_token_name_str[] = {
(char *)&_TOKNAM_ILLEGAL_CHARACTER,
#include "objm2_keyword_table.h"
#include "objm2_token_table.h"
} /* token_name_str */;

#undef _add_token
#undef _add_keyword


// ---------------------------------------------------------------------------
// function:  objm2_token_name(token)
// ---------------------------------------------------------------------------
//
// Returns the human readable name for token <token>.
// Returns NULL if the value of <token> is invalid.

const char *objm2_token_name(objm2_token_t token) {

    if (token < NUMBER_OF_TOKENS)
        return objm2_token_name_str[token];
    else 
        return NULL;
    
} // end objm2_token_name


// END OF FILE