/* Objective Modula-2 Compiler (objm2c)
 *
 *  objm2_tokens.h
 *  Definition of compiler tokens and their values
 *
 *  Author: Benjamin Kowarsch
 *
 *  Copyright (C) 2009 Sunrise Telephone Systems KK. All rights reserved.
 *
 *  License:
 *
 *  Permission is hereby granted to review and test this software for the sole
 *  purpose of supporting the effort by the licensor to define and develop the
 *  Objective Modula-2 language. It is not permissible under any circumstances
 *  to  use the software  for the purpose  of creating derivative languages or 
 *  dialects.  This permission is valid until 31 December 2009, 24:00h GMT.
 *
 *  Future licensing:
 *
 *  The licensor undertakes to eventually release this software under a proper
 *  open source license  AFTER  the Objective Modula-2 language definition has
 *  been finalised and a conforming and working reference compiler completed.
 *  
 *  Version history:
 *
 *   2.00   2009-01-31   BK   new file
 */


#ifndef OBJM2_TOKENS_H
#define OBJM2_TOKENS_H


// ---------------------------------------------------------------------------
// Enumeration type containing all tokens
// ---------------------------------------------------------------------------

#define _add_token(_suffix, _desc) TOKEN ## _suffix,
#define _add_keyword(_suffix, _hash) TOKEN ## _suffix,

typedef /* objm2_token_t */ enum {
TOKEN_ILLEGAL_CHARACTER = 0, // MUST BE FIRST TOKEN WITH VALUE ZERO
#include "objm2_keyword_table.h" // KEYWORDS MUST FOLLOW FIRST TOKEN
#include "objm2_token_table.h" // ALL OTHER TOKENS MUST FOLLOW KEYWORDS
NUMBER_OF_TOKENS // PSEUDO ENTRY TO OBTAIN THE NUMBER OF TOKENS
} objm2_token_t;

#undef _add_token
#undef _add_keyword


// --------------------------------------------------------------------------
// Token aliases for convenience
// --------------------------------------------------------------------------

#define TOKEN_ILLEGAL_CHAR   TOKEN_ILLEGAL_CHARACTER
#define TOKEN_IDENT          TOKEN_IDENTIFIER
#define TOKEN_LABELED_IDENT  TOKEN_LABELED_IDENTIFIER
#define TOKEN_OCT_LITERAL    TOKEN_OCTAL_INTEGER_LITERAL
#define TOKEN_DEC_LITERAL    TOKEN_DECIMAL_INTEGER_LITERAL
#define TOKEN_HEX_LITERAL    TOKEN_SEDECIMAL_INTEGER_LITERAL
#define TOKEN_FP_LITERAL     TOKEN_REAL_INTEGER_LITERAL
#define TOKEN_LPAREN         TOKEN_OPENING_PARENTHESIS
#define TOKEN_RPAREN         TOKEN_CLOSING_PARENTHESIS
#define TOKEN_LBRACKET       TOKEN_OPENING_SQUARE_BRACKET
#define TOKEN_RBRACKET       TOKEN_CLOSING_SQUARE_BRACKET
#define TOKEN_LBRACE         TOKEN_OPENING_CURLY_BRACE
#define TOKEN_RBRACE         TOKEN_CLOSING_CURLY_BRACE


// ---------------------------------------------------------------------------
// function:  objm2_token_name(token)
// ---------------------------------------------------------------------------
//
// Returns the human readable name for token <token>.
// Returns NULL if the value of <token> is invalid.

const char *objm2_token_name(objm2_token_t token);


#endif /* OBJM2_TOKENS_H */

// END OF FILE